/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.core.model;

import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.GitRepositoryProvider;
import com.aptana.git.core.model.GitExecutable;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.IGitRepositoriesListener;
import com.aptana.git.core.model.IGitRepositoryListener;
import com.aptana.git.core.model.IGitRepositoryManager;
import com.aptana.git.core.model.Messages;
import com.aptana.git.core.model.RepositoryAddedEvent;
import com.aptana.git.core.model.RepositoryRemovedEvent;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.team.core.IIgnoreInfo;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;

public class GitRepositoryManager
implements IGitRepositoryManager {
    private static final String GIT_DIR = ".git";
    private Set<IGitRepositoriesListener> listeners = new HashSet<IGitRepositoriesListener>();
    private Map<String, GitRepository> cachedRepos = new HashMap<String, GitRepository>(3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IGitRepositoriesListener listener) {
        Set<IGitRepositoriesListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IGitRepositoriesListener listener) {
        Set<IGitRepositoriesListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Object object = this.listeners;
        synchronized (object) {
            this.listeners.clear();
        }
        object = this.cachedRepos;
        synchronized (object) {
            for (GitRepository reference : this.cachedRepos.values()) {
                if (reference == null) continue;
                reference.dispose();
            }
            this.cachedRepos.clear();
        }
    }

    public void create(IPath path) {
        GitRepository repo;
        IStatus result;
        File file;
        URI existing;
        if (path == null) {
            return;
        }
        if (path.lastSegment().equals(GIT_DIR)) {
            path = path.removeLastSegments(1);
        }
        if ((existing = this.gitDirForURL((file = path.toFile()).toURI())) != null) {
            return;
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        if ((result = GitExecutable.instance().runInBackground(path, "init")) != null && result.isOK() && (repo = this.getUnattachedExisting(path.toFile().toURI())) != null) {
            IIgnoreInfo[] infos;
            IIgnoreInfo[] iIgnoreInfoArray = infos = Team.getAllIgnores();
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                IIgnoreInfo info = iIgnoreInfoArray[n2];
                if (info != null && info.getEnabled() && !info.getPattern().equals(GIT_DIR)) {
                    repo.ignore(info.getPattern());
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepository(IProject p) {
        GitRepository repo = this.getUnattachedExisting(p.getLocationURI());
        if (repo == null) {
            return;
        }
        boolean dispose = true;
        Map<String, GitRepository> map = this.cachedRepos;
        synchronized (map) {
            this.cachedRepos.remove(p.getLocationURI().getPath());
            for (GitRepository ref : this.cachedRepos.values()) {
                if (ref == null || !ref.equals(repo)) continue;
                dispose = false;
                break;
            }
        }
        RepositoryRemovedEvent e = new RepositoryRemovedEvent(repo, p);
        for (IGitRepositoriesListener listener : this.listeners) {
            listener.repositoryRemoved(e);
        }
        if (dispose) {
            repo.dispose();
            repo = null;
        }
    }

    public GitRepository getAttached(IProject project) {
        if (project == null) {
            return null;
        }
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project, (String)GitRepositoryProvider.ID);
        if (provider == null) {
            return null;
        }
        return this.getUnattachedExisting(project.getLocationURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitRepository getUnattachedExisting(URI path) {
        if (GitExecutable.instance() == null || GitExecutable.instance().path() == null || path == null) {
            return null;
        }
        Map<String, GitRepository> map = this.cachedRepos;
        synchronized (map) {
            URI gitDirURL;
            GitRepository ref;
            block7: {
                ref = this.cachedRepos.get(path.getPath());
                if (ref != null) {
                    return ref;
                }
                gitDirURL = this.gitDirForURL(path);
                if (gitDirURL != null) break block7;
                return null;
            }
            for (GitRepository reference : this.cachedRepos.values()) {
                if (reference == null || !reference.getFileURL().getPath().equals(gitDirURL.getPath())) continue;
                this.cachedRepos.put(path.getPath(), reference);
                return reference;
            }
            ref = new GitRepository(gitDirURL);
            this.cachedRepos.put(path.getPath(), ref);
            return ref;
        }
    }

    public GitRepository attachExisting(IProject project, IProgressMonitor m) throws CoreException {
        if (m == null) {
            m = new NullProgressMonitor();
        }
        GitRepository repo = this.getUnattachedExisting(project.getLocationURI());
        m.worked(40);
        if (repo == null) {
            return null;
        }
        try {
            RepositoryProvider.map((IProject)project, (String)GitRepositoryProvider.ID);
            m.worked(10);
            this.fireRepositoryAddedEvent(repo, project);
            m.worked(50);
        }
        catch (TeamException e) {
            throw new CoreException((IStatus)new Status(4, GitPlugin.getPluginId(), e.getMessage(), (Throwable)e));
        }
        return repo;
    }

    private void fireRepositoryAddedEvent(GitRepository repo, IProject project) {
        RepositoryAddedEvent e = new RepositoryAddedEvent(repo, project);
        for (IGitRepositoriesListener listener : this.listeners) {
            listener.repositoryAdded(e);
        }
    }

    public URI gitDirForURL(URI repositoryURL) {
        if (GitExecutable.instance() == null) {
            return null;
        }
        IPath repositoryPath = Path.fromOSString((String)repositoryURL.getPath());
        if (repositoryURL.getScheme().equals("file")) {
            repositoryPath = Path.fromOSString((String)new File(repositoryURL).getAbsolutePath());
        }
        if (!repositoryPath.toFile().exists()) {
            return null;
        }
        File gitDir = repositoryPath.append(GIT_DIR).toFile();
        if (gitDir.isDirectory()) {
            return gitDir.toURI();
        }
        IStatus result = GitExecutable.instance().runInBackground(repositoryPath, "rev-parse", "--git-dir");
        if (result == null || !result.isOK()) {
            return null;
        }
        String newPath = result.getMessage();
        if (newPath == null) {
            return null;
        }
        if (newPath.equals(GIT_DIR)) {
            return repositoryPath.append(GIT_DIR).toFile().toURI();
        }
        if (newPath.length() > 0) {
            return new File(newPath).toURI();
        }
        return null;
    }

    public void addListenerToEachRepository(IGitRepositoryListener listener) {
        if (listener == null) {
            return;
        }
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            GitRepository repo = this.getAttached(project);
            if (repo != null) {
                repo.addListener(listener);
            }
            ++n2;
        }
    }

    public void removeListenerFromEachRepository(IGitRepositoryListener listener) {
        if (listener == null) {
            return;
        }
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            GitRepository repo = this.getAttached(project);
            if (repo != null) {
                repo.removeListener(listener);
            }
            ++n2;
        }
    }

    public GitRepository createOrAttach(IProject project, IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (GitExecutable.instance() == null) {
                throw new CoreException((IStatus)new Status(4, GitPlugin.getPluginId(), Messages.GitRepositoryManager_UnableToFindGitExecutableError));
            }
            GitRepository repo = this.getUnattachedExisting(project.getLocationURI());
            if (repo == null) {
                if (sub.isCanceled()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                this.create(project.getLocation());
            }
            sub.worked(50);
            if (sub.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            GitRepository gitRepository = this.attachExisting(project, (IProgressMonitor)sub.newChild(50));
            return gitRepository;
        }
        finally {
            sub.done();
        }
    }
}

